package com.rockysaas.api.demo.util;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.google.gson.Gson;

/**
 * 操作一些Map的方法
 * 
 * @author AMARKY
 * @date 2016-5-17
 * @Description
 */
public class MapUtil {

	private static Logger logger = LoggerFactory.getLogger(MapUtil.class);

	private static final String ENCRYPTION_KEY = "encryptionKey";
	private static final String SPLIT = "&";
	private static final String SIGN = "sign";

	private static final Gson gson = new Gson();

	/**
	 * 将这个对象中的get方法放入Map Map中的键值对
	 * <Key,value>---><传入的对象的属性名称(去掉get,全部转成大写),该对象的属性方法返回的数据(没有就是"")>
	 * 
	 * @param c
	 * @return
	 */
	public static Map<String, Object> getMapByClassAttributeValue(Object c) {
		Map<String, Object> classAttributeValue = new HashMap<String, Object>();
		return getMapByClassAttributeValue(classAttributeValue, c);
	}

	/**
	 * 需要传入的map
	 * 
	 * @param classAttributeValue
	 * @param c
	 * @return
	 */
	public static Map<String, Object> getMapByClassAttributeValue(Map<String, Object> classAttributeValue, Object c) {
		try {
			Class<? extends Object> clazz = c.getClass();
			Method[] methods = clazz.getMethods();
			for (int i = 0; i < methods.length; i++) {
				if (methods[i].getName().startsWith("get") && !methods[i].getName().equals("getClass")) {
					String methodName = methods[i].getName().substring(3);
					// 转成大写
					methodName = methodName.toUpperCase();
					Object o = methods[i].invoke(c);// 执行get方法返回一个Object
					classAttributeValue.put(methodName, o);
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		return classAttributeValue;
	}

	/**
	 * 对map按照key值进行排序
	 * 
	 * @param map
	 * @return Map.Entry[]
	 */
	public static Map.Entry[] getSortedHashtableByValue(Map<String, Object> map) {
		Set set = map.entrySet();
		Map.Entry[] entries = (Map.Entry[]) set.toArray(new Map.Entry[set.size()]);
		Arrays.sort(entries, new Comparator() {
			@Override
			public int compare(Object arg0, Object arg1) {
				String key1 = ((Map.Entry) arg0).getKey().toString();
				String key2 = ((Map.Entry) arg1).getKey().toString();
				return key1.compareTo(key2);
			}
		});

		return entries;
	}

	/**
	 * 
	 * @Description 按属性－值组装Map
	 * @author <a href="hugaoxiang8619@adpanshi.com">hugaoxiang</a>
	 * @param objects
	 * @return
	 * @throws Exception
	 */
	public static Map<String, Object> getMapFromObject(Object... objects) throws Exception {
		return getMapFromObject(null, objects);
	}

	/**
	 * 
	 * @Description
	 * @author <a href="hugaoxiang8619@adpanshi.com">hugaoxiang</a>
	 * @param annotation
	 * @param objects
	 * @return
	 * @throws Exception
	 */
	public static Map<String, Object> getMapFromObject(Class annotation, Object... objects) throws Exception {
		Map map = new HashMap();
		for (Object obj : objects) {
			Class cls = obj.getClass();
			getBeanFields(cls, obj, map, annotation);
		}

		return map;
	}

	/**
	 * 
	 * @Description
	 * @author <a href="hugaoxiang8619@adpanshi.com">hugaoxiang</a>
	 * @param cls
	 * @param obj
	 * @param map
	 * @param annotation
	 * @throws IllegalArgumentException
	 * @throws IllegalAccessException
	 * @throws InvocationTargetException
	 */
	private static void getBeanFields(Class cls, Object obj, Map map, Class annotation)
			throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {

		for (Field field : cls.getDeclaredFields()) {
			String fieldName = field.getName();

			field.setAccessible(true);
			Type type = field.getGenericType();
			if (annotation != null) {
				Object annObj = field.getAnnotation(annotation);
				if (annObj != null) {
					Method[] methods = annObj.getClass().getDeclaredMethods();
					Method method = methods[0];
					Object result = method.invoke(annObj, null);
					map.put(result.toString(), field.get(obj));

				} else {
					map.put(field.getName(), field.get(obj));
				}

			} else {
				map.put(field.getName(), field.get(obj));
			}
		}
		if (cls.getSuperclass() != null) {
			getBeanFields(cls.getSuperclass(), obj, map, annotation);
		}
	}

	public static List<Map<String, Object>> mapDateSort(List<Map<String, Object>> repaymentList, String sort,
			String column, String pattern) {
		Collections.sort(repaymentList, new Comparator<Map<String, Object>>() {
			@Override
			public int compare(Map<String, Object> o1, Map<String, Object> o2) {
				SimpleDateFormat format = new SimpleDateFormat(pattern);
				String s1 = o1.get(column).toString();
				String s2 = o2.get(column).toString();
				Long val1 = (long) 0;
				Long val2 = (long) 0;
				try {
					val1 = format.parse(s1).getTime();
					val2 = format.parse(s2).getTime();
				} catch (ParseException e) {
					logger.error(e.getMessage(), e);
				}
				if (sort.equals("asc")) {
					return val1.compareTo(val2);
				} else {
					return val2.compareTo(val1);
				}
			}
		});
		return repaymentList;
	}
}
