package com.rockysaas.api.demo.util;

import java.io.UnsupportedEncodingException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Security;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.HashMap;
import java.util.Map;

import org.apache.commons.codec.binary.Base64;

public class RSAUtil {
	public static final String ENCRYPTION_ALGORITHM = "RSA";

	public static final String SIGNATURE_ALGORITHM = "MD5withRSA";

	static {
		Security.addProvider(new org.bouncycastle.jce.provider.BouncyCastleProvider());
	}

	/**
	 * 对信息生成数字签名（用私钥）
	 */
	public static String sign(byte[] data, String keyString) throws Exception {
		Map<String, Object> keyAndFactoryMap = RSAUtil.generateKeyAndFactory(keyString, false);
		Key key = RSAUtil.getKey(keyAndFactoryMap);

		PrivateKey privateKey = (PrivateKey) key;

		// 用私钥对信息生成数字签名
		Signature signature = Signature.getInstance(SIGNATURE_ALGORITHM);
		signature.initSign(privateKey);
		signature.update(data);
		return Base64.encodeBase64String(signature.sign());
	}

//	/**
//	 * 校验数字签名（用公钥）
//	 */
//	public static boolean verify(byte[] data, String keyString, String sign) throws Exception {
//		Map<String, Object> keyAndFactoryMap = RSAUtil.generateKeyAndFactory(keyString, true);
//		Key key = RSAUtil.getKey(keyAndFactoryMap);
//
//		PublicKey publicKey = (PublicKey) key;
//
//		// 取公钥匙对象
//		Signature signature = Signature.getInstance(SIGNATURE_ALGORITHM);
//		signature.initVerify(publicKey);
//		signature.update(data);
//
//		// 验证签名是否正常
//		return signature.verify(Base64.decodeBase64(sign));
//	}

	/**
	 * 生成钥匙
	 */
	public static Map<String, Object> generateKeyAndFactory(String keyString, boolean isPublic) throws Exception {
		byte[] keyBytes = Base64.decodeBase64(keyString);
		KeyFactory keyFactory = KeyFactory.getInstance(ENCRYPTION_ALGORITHM);
		Key key = null;
		if (isPublic) {
			X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(keyBytes);
			key = keyFactory.generatePublic(x509KeySpec);
		} else {
			PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(keyBytes);
			key = keyFactory.generatePrivate(pkcs8KeySpec);
		}

		Map<String, Object> keyAndFactoryMap = new HashMap<String, Object>(2);
		keyAndFactoryMap.put("key", key);
		keyAndFactoryMap.put("keyFactory", keyFactory);

		return keyAndFactoryMap;
	}

	/**
	 * 验证签名
	 *
	 * @param data     数据
	 * @param sign     签名
	 * @param pubicKey 公钥
	 * @return
	 */
	public static boolean verifySign(String data, String sign, PublicKey pubicKey) {
		try {
			byte[] dataByte = data.getBytes("UTF-8");
			byte[] signByte = BASE64.decode(sign.getBytes("UTF-8"));
			return verifySign(dataByte, signByte, pubicKey);
		} catch (UnsupportedEncodingException e) {

			throw new RuntimeException("verifySign fail! data[" + data + "] sign[" + sign + "]", e);
		}
	}

	/**
	 * 验证签名
	 *
	 * @param data      数据
	 * @param sign      签名
	 * @param publicKey 公钥
	 * @return
	 */
	public static boolean verifySign(byte[] data, byte[] sign, PublicKey publicKey) {
		try {
			Signature signature = Signature.getInstance("MD5withRSA");
			signature.initVerify(publicKey);
			signature.update(data);
			boolean result = signature.verify(sign);
			return result;
		} catch (Exception e) {

			throw new RuntimeException("verifySign fail!", e);
		}
	}

	/**
	 * 从指定对象中获取钥匙
	 */
	public static Key getKey(Map<String, Object> map) {
		if (map.get("key") == null) {
			return null;
		}
		return (Key) map.get("key");
	}

}
