package com.rockysaas.api.demo;

import static org.springframework.test.web.servlet.request.MockMvcRequestBuilders.post;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.status;

import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.http.MediaType;
import org.springframework.test.context.junit4.SpringRunner;
import org.springframework.test.context.web.WebAppConfiguration;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.result.MockMvcResultHandlers;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;
import org.springframework.web.context.WebApplicationContext;

import com.alibaba.fastjson.JSON;
import com.rockysaas.api.demo.model.OpenProviderReceiveRequestDto;
import com.rockysaas.api.demo.model.SaasUserInitNotifyReqDto;
import com.rockysaas.api.demo.util.MapUtil;
import com.rockysaas.api.demo.util.RSAUtil;

import lombok.extern.slf4j.Slf4j;

@RunWith(SpringRunner.class)
@SpringBootTest(classes = RockysaasApiDemoApplication.class)
@WebAppConfiguration
@Slf4j
public class RockysaasApiDemoApplicationTests {
	private static final Set<String> SIGN_EXCLUDE_SET = new HashSet<>();

	@Value(value = "${rockysaas.open.saas.private-key}")
	private String privateKey;

	static {
		SIGN_EXCLUDE_SET.add("sign");
	}

	private MockMvc mvc;

	@Autowired
	protected WebApplicationContext wac;

	@Test
	public void signTest() {
		OpenProviderReceiveRequestDto request = new OpenProviderReceiveRequestDto();

		request.setAppId("1234");
		request.setMethod("api.saas.v1.user.init-result-notify");

		SaasUserInitNotifyReqDto reqDto = new SaasUserInitNotifyReqDto();
		reqDto.setOrderNo("726723761214065669");
		reqDto.setSecretKey("secret6");
		reqDto.setUserName("test7");

		request.setBizParams(JSON.toJSONString(reqDto));
		request.setTimestamp(String.valueOf(new Date().getTime()));

		try {

			Map<String, Object> map = MapUtil.getMapFromObject(request);
			String sign = sign(map);
			request.setSign(sign);
			log.info("request = " + JSON.toJSONString(request));
			mvc.perform(post("/api/").contentType(MediaType.APPLICATION_JSON).content(JSON.toJSONString(request)))
					.andExpect(status().isOk()).andDo(MockMvcResultHandlers.print()).andReturn(); // 数据的格式
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	private String sign(Map<String, Object> parameters) throws Exception {
		SortedMap<String, Object> sortedParameters = new TreeMap<>(parameters);
		log.info(JSON.toJSONString(sortedParameters));

		StringBuffer sb = new StringBuffer();
		for (Map.Entry<String, Object> entry : sortedParameters.entrySet()) {
			String k = entry.getKey();
			if (!"sign".equals(k)) {
				String v = entry.getValue().toString();
				sb.append("&" + k + "=" + v);
			}

		}

		if (sb.length() > 0) {
			String paramsStr = sb.deleteCharAt(0).toString();
			log.info("签名前字符串：" + paramsStr);
			// MD5withRSA
			String sign = RSAUtil.sign(paramsStr.getBytes(), this.privateKey);
			log.info("签名结果：" + sign);

			return sign;
		}
		return null;
	}

	@Before() // 这个方法在每个方法执行之前都会执行一遍
	public void setup() {
		mvc = MockMvcBuilders.webAppContextSetup(wac).build(); // 初始化MockMvc对象
	}

}
